'use client';

import { useState } from 'react';
import Link from 'next/link';
import Image from 'next/image';
import { motion } from 'framer-motion';
import { Menu, X, Sparkles } from 'lucide-react';

/**
 * Header component with navigation and branding
 */
export default function Header() {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  return (
    <header className="fixed top-0 left-0 right-0 z-50 bg-white border-b border-gray-100 shadow-sm">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex items-center justify-between h-16 md:h-20">
          {/* beLIVE Logo - Unchanged */}
          <Link href="/" className="flex items-center group">
            <div className="relative h-10 w-28 sm:h-12 sm:w-32">
              <Image
                src="/belive-logo.png"
                alt="beLIVE"
                fill
                className="object-contain"
                priority
              />
            </div>
          </Link>

          {/* Desktop Navigation */}
          <nav className="hidden md:flex items-center gap-8">
            <Link 
              href="/" 
              className="text-sm font-medium text-gray-600 hover:text-[#E11D2E] transition-colors relative group"
            >
              Discover
              <span className="absolute -bottom-1 left-0 w-0 h-0.5 bg-[#E11D2E] group-hover:w-full transition-all duration-300" />
            </Link>
            <Link 
              href="/#featured" 
              className="text-sm font-medium text-gray-600 hover:text-[#E11D2E] transition-colors relative group"
            >
              Featured
              <span className="absolute -bottom-1 left-0 w-0 h-0.5 bg-[#E11D2E] group-hover:w-full transition-all duration-300" />
            </Link>
            <Link 
              href="/#categories" 
              className="text-sm font-medium text-gray-600 hover:text-[#E11D2E] transition-colors relative group"
            >
              Categories
              <span className="absolute -bottom-1 left-0 w-0 h-0.5 bg-[#E11D2E] group-hover:w-full transition-all duration-300" />
            </Link>
          </nav>

          {/* CTA Button */}
          <div className="hidden md:flex items-center gap-4">
            <button className="btn-primary text-sm flex items-center gap-2">
              <Sparkles className="w-4 h-4" />
              Refresh Events
            </button>
          </div>

          {/* Mobile Menu Button */}
          <button 
            className="md:hidden p-2 text-gray-600 hover:text-[#E11D2E] transition-colors"
            onClick={() => setIsMenuOpen(!isMenuOpen)}
            aria-label="Toggle menu"
          >
            {isMenuOpen ? <X className="w-6 h-6" /> : <Menu className="w-6 h-6" />}
          </button>
        </div>

        {/* Mobile Navigation */}
        {isMenuOpen && (
          <motion.nav 
            initial={{ opacity: 0, height: 0 }}
            animate={{ opacity: 1, height: 'auto' }}
            exit={{ opacity: 0, height: 0 }}
            className="md:hidden py-4 border-t border-gray-100"
          >
            <div className="flex flex-col gap-4">
              <Link 
                href="/" 
                className="text-sm font-medium text-gray-600 hover:text-[#E11D2E] transition-colors"
                onClick={() => setIsMenuOpen(false)}
              >
                Discover
              </Link>
              <Link 
                href="/#featured" 
                className="text-sm font-medium text-gray-600 hover:text-[#E11D2E] transition-colors"
                onClick={() => setIsMenuOpen(false)}
              >
                Featured
              </Link>
              <Link 
                href="/#categories" 
                className="text-sm font-medium text-gray-600 hover:text-[#E11D2E] transition-colors"
                onClick={() => setIsMenuOpen(false)}
              >
                Categories
              </Link>
              <button className="btn-primary text-sm flex items-center justify-center gap-2 w-full mt-2">
                <Sparkles className="w-4 h-4" />
                Refresh Events
              </button>
            </div>
          </motion.nav>
        )}
      </div>
    </header>
  );
}
